/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.json.core.parsing.JSONFlexScanner;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JSONSourceScanner
extends AbstractFlexTokenScanner {
    private static final Token UNDEFINED_TOKEN = new Token((Object)"");
    private static final Token NUMBER_TOKEN = new Token((Object)"constant.numeric.json");
    private static final Token KEYWORD_OPERATOR = new Token((Object)"keyword.operator.json");
    private static final Token NULL = new Token((Object)"constant.language.null.json");
    private static final Token TRUE = new Token((Object)"constant.language.boolean.true.json");
    private static final Token FALSE = new Token((Object)"constant.language.boolean.false.json");
    private static final Token COMMA = new Token((Object)"meta.delimiter.object.comma.json");
    private static final Token CURLY = new Token((Object)"meta.brace.curly.json");
    private static final Token BRACKET = new Token((Object)"meta.brace.square.json");

    protected JSONSourceScanner() {
        super((Scanner)new JSONFlexScanner());
    }

    protected void setSource(String source) {
        ((JSONFlexScanner)this.fScanner).setSource(source);
    }

    protected IToken getUndefinedToken() {
        return UNDEFINED_TOKEN;
    }

    protected IToken mapToken(Symbol token) throws IOException, Scanner.Exception {
        switch (token.getId()) {
            case 7: {
                return NULL;
            }
            case 5: {
                return TRUE;
            }
            case 6: {
                return FALSE;
            }
            case 10: {
                return COMMA;
            }
            case 3: 
            case 9: {
                return BRACKET;
            }
            case 2: 
            case 8: {
                return CURLY;
            }
            case 11: {
                return KEYWORD_OPERATOR;
            }
            case 4: {
                return NUMBER_TOKEN;
            }
            case 0: {
                return Token.EOF;
            }
        }
        IdeLog.logWarning((Plugin)JSONPlugin.getDefault(), (String)MessageFormat.format("JSONSourceScanner: Token not mapped: {0}>>{1}<<", token.getId(), token.value));
        return UNDEFINED_TOKEN;
    }
}

